/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.decoder;

import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;

final class FormatInformation {
    private static final int FORMAT_INFO_MASK_QR = 21522;
    private static final int[][] FORMAT_INFO_DECODE_LOOKUP;
    private static final int[] BITS_SET_IN_HALF_BYTE;
    private final ErrorCorrectionLevel errorCorrectionLevel;
    private final byte dataMask;

    static {
        int[][] nArrayArray = new int[32][];
        int[] nArray = new int[2];
        nArray[0] = 21522;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{20773, 1};
        nArrayArray[2] = new int[]{24188, 2};
        nArrayArray[3] = new int[]{23371, 3};
        nArrayArray[4] = new int[]{17913, 4};
        nArrayArray[5] = new int[]{16590, 5};
        nArrayArray[6] = new int[]{20375, 6};
        nArrayArray[7] = new int[]{19104, 7};
        nArrayArray[8] = new int[]{30660, 8};
        nArrayArray[9] = new int[]{29427, 9};
        nArrayArray[10] = new int[]{32170, 10};
        nArrayArray[11] = new int[]{30877, 11};
        nArrayArray[12] = new int[]{26159, 12};
        nArrayArray[13] = new int[]{25368, 13};
        nArrayArray[14] = new int[]{27713, 14};
        nArrayArray[15] = new int[]{26998, 15};
        nArrayArray[16] = new int[]{5769, 16};
        nArrayArray[17] = new int[]{5054, 17};
        nArrayArray[18] = new int[]{7399, 18};
        nArrayArray[19] = new int[]{6608, 19};
        nArrayArray[20] = new int[]{1890, 20};
        nArrayArray[21] = new int[]{597, 21};
        nArrayArray[22] = new int[]{3340, 22};
        nArrayArray[23] = new int[]{2107, 23};
        nArrayArray[24] = new int[]{13663, 24};
        nArrayArray[25] = new int[]{12392, 25};
        nArrayArray[26] = new int[]{16177, 26};
        nArrayArray[27] = new int[]{14854, 27};
        nArrayArray[28] = new int[]{9396, 28};
        nArrayArray[29] = new int[]{8579, 29};
        nArrayArray[30] = new int[]{11994, 30};
        nArrayArray[31] = new int[]{11245, 31};
        FORMAT_INFO_DECODE_LOOKUP = nArrayArray;
        int[] nArray2 = new int[16];
        nArray2[1] = 1;
        nArray2[2] = 1;
        nArray2[3] = 2;
        nArray2[4] = 1;
        nArray2[5] = 2;
        nArray2[6] = 2;
        nArray2[7] = 3;
        nArray2[8] = 1;
        nArray2[9] = 2;
        nArray2[10] = 2;
        nArray2[11] = 3;
        nArray2[12] = 2;
        nArray2[13] = 3;
        nArray2[14] = 3;
        nArray2[15] = 4;
        BITS_SET_IN_HALF_BYTE = nArray2;
    }

    private FormatInformation(int formatInfo) {
        this.errorCorrectionLevel = ErrorCorrectionLevel.forBits(formatInfo >> 3 & 3);
        this.dataMask = (byte)(formatInfo & 7);
    }

    static int numBitsDiffering(int a, int b) {
        return BITS_SET_IN_HALF_BYTE[(a ^= b) & 0xF] + BITS_SET_IN_HALF_BYTE[a >>> 4 & 0xF] + BITS_SET_IN_HALF_BYTE[a >>> 8 & 0xF] + BITS_SET_IN_HALF_BYTE[a >>> 12 & 0xF] + BITS_SET_IN_HALF_BYTE[a >>> 16 & 0xF] + BITS_SET_IN_HALF_BYTE[a >>> 20 & 0xF] + BITS_SET_IN_HALF_BYTE[a >>> 24 & 0xF] + BITS_SET_IN_HALF_BYTE[a >>> 28 & 0xF];
    }

    static FormatInformation decodeFormatInformation(int maskedFormatInfo1, int maskedFormatInfo2) {
        FormatInformation formatInfo = FormatInformation.doDecodeFormatInformation(maskedFormatInfo1, maskedFormatInfo2);
        if (formatInfo != null) {
            return formatInfo;
        }
        return FormatInformation.doDecodeFormatInformation(maskedFormatInfo1 ^ 0x5412, maskedFormatInfo2 ^ 0x5412);
    }

    private static FormatInformation doDecodeFormatInformation(int maskedFormatInfo1, int maskedFormatInfo2) {
        int bestDifference = Integer.MAX_VALUE;
        int bestFormatInfo = 0;
        int[][] nArray = FORMAT_INFO_DECODE_LOOKUP;
        int n = FORMAT_INFO_DECODE_LOOKUP.length;
        int n2 = 0;
        while (n2 < n) {
            int[] decodeInfo = nArray[n2];
            int targetInfo = decodeInfo[0];
            if (targetInfo == maskedFormatInfo1 || targetInfo == maskedFormatInfo2) {
                return new FormatInformation(decodeInfo[1]);
            }
            int bitsDifference = FormatInformation.numBitsDiffering(maskedFormatInfo1, targetInfo);
            if (bitsDifference < bestDifference) {
                bestFormatInfo = decodeInfo[1];
                bestDifference = bitsDifference;
            }
            if (maskedFormatInfo1 != maskedFormatInfo2 && (bitsDifference = FormatInformation.numBitsDiffering(maskedFormatInfo2, targetInfo)) < bestDifference) {
                bestFormatInfo = decodeInfo[1];
                bestDifference = bitsDifference;
            }
            ++n2;
        }
        if (bestDifference <= 3) {
            return new FormatInformation(bestFormatInfo);
        }
        return null;
    }

    ErrorCorrectionLevel getErrorCorrectionLevel() {
        return this.errorCorrectionLevel;
    }

    byte getDataMask() {
        return this.dataMask;
    }

    public int hashCode() {
        return this.errorCorrectionLevel.ordinal() << 3 | this.dataMask;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FormatInformation)) {
            return false;
        }
        FormatInformation other = (FormatInformation)o;
        return this.errorCorrectionLevel == other.errorCorrectionLevel && this.dataMask == other.dataMask;
    }
}

