/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.android.common.net;

import android.content.Context;
import android.text.TextUtils;
import com.baidu.android.common.logging.Log;
import com.baidu.android.common.net.ConnectManager;
import java.io.IOException;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public class ProxyHttpClient
extends DefaultHttpClient {
    private static final String TAG = ProxyHttpClient.class.getSimpleName();
    private static final boolean DEBUG = false;
    private String mProxy;
    private String mPort;
    private boolean mUseWap;
    private static final int HTTP_TIMEOUT_MS = 30000;
    private RuntimeException mLeakedException = new IllegalStateException("ProxyHttpClient created and never closed");

    public ProxyHttpClient(Context context) {
        this(context, null, null);
    }

    public ProxyHttpClient(Context context, String string) {
        this(context, string, null);
    }

    public ProxyHttpClient(Context context, ConnectManager connectManager) {
        this(context, null, connectManager);
    }

    public ProxyHttpClient(Context context, String string, ConnectManager connectManager) {
        ConnectManager connectManager2 = connectManager;
        if (connectManager2 == null) {
            connectManager2 = new ConnectManager(context);
        }
        this.mUseWap = connectManager2.isWapNetwork();
        this.mProxy = connectManager2.getProxy();
        this.mPort = connectManager2.getProxyPort();
        if (this.mProxy != null && this.mProxy.length() > 0) {
            HttpHost httpHost = new HttpHost(this.mProxy, Integer.valueOf(this.mPort).intValue());
            this.getParams().setParameter("http.route.default-proxy", (Object)httpHost);
        }
        HttpConnectionParams.setConnectionTimeout((HttpParams)this.getParams(), (int)30000);
        HttpConnectionParams.setSoTimeout((HttpParams)this.getParams(), (int)30000);
        HttpConnectionParams.setSocketBufferSize((HttpParams)this.getParams(), (int)8192);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            HttpProtocolParams.setUserAgent((HttpParams)this.getParams(), (String)string);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.mLeakedException != null) {
            Log.e(TAG, "Leak found", this.mLeakedException);
        }
    }

    public void close() {
        if (this.mLeakedException != null) {
            this.getConnectionManager().shutdown();
            this.mLeakedException = null;
        }
    }

    public boolean isWap() {
        return this.mUseWap;
    }

    protected HttpParams createHttpParams() {
        HttpParams httpParams;
        try {
            httpParams = super.createHttpParams();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            httpParams = new BasicHttpParams();
            HttpProtocolParams.setVersion((HttpParams)httpParams, (ProtocolVersion)HttpVersion.HTTP_1_1);
            HttpProtocolParams.setContentCharset((HttpParams)httpParams, (String)"ISO-8859-1");
            HttpProtocolParams.setUserAgent((HttpParams)httpParams, (String)"Apache-HttpClient/UNAVAILABLE (java 1.4)");
        }
        HttpProtocolParams.setUseExpectContinue((HttpParams)httpParams, (boolean)false);
        return httpParams;
    }

    public HttpResponse executeSafely(HttpUriRequest httpUriRequest) throws ClientProtocolException, IOException {
        try {
            return this.execute(httpUriRequest);
        }
        catch (NullPointerException nullPointerException) {
            throw new ClientProtocolException((Throwable)nullPointerException);
        }
    }
}

