/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.alsa;

import android.util.Log;
import com.iflytek.alsa.jni.AlsaJni;

public class AlsaRecorder {
    private static String TAG = "AlsaRecorder";
    private static AlsaRecorder instance;
    private static int card;
    private static int sampleRate;
    private static int periodSize;
    private static int pcmHandle;
    private a a;
    private PcmListener b;
    private boolean c;
    private int d = -1;
    private Object e = new Object();

    static {
        card = 2;
        sampleRate = 96000;
        periodSize = 1536;
        pcmHandle = 0;
    }

    private AlsaRecorder(int n2, int n3, int n4) {
        card = n2;
        sampleRate = n3;
        periodSize = n4;
    }

    public static AlsaRecorder createInstance(int n2) {
        return AlsaRecorder.createInstance(n2, sampleRate, periodSize);
    }

    public static AlsaRecorder createInstance(int n2, int n3) {
        return AlsaRecorder.createInstance(n2, n3, periodSize);
    }

    public static AlsaRecorder createInstance(int n2, int n3, int n4) {
        AlsaJni.loadLib();
        if (instance == null) {
            instance = new AlsaRecorder(n2, n3, n4);
        }
        return instance;
    }

    public static AlsaRecorder getInstance() {
        return instance;
    }

    public void setBufferSize(int n2) {
        this.d = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startRecording(PcmListener pcmListener) {
        if (instance == null) {
            Log.e((String)TAG, (String)"startRecording | AlsaRecorder instance is null.");
            return -1;
        }
        if (this.c) {
            Log.e((String)TAG, (String)"startRecording | be repeatedly called.");
            return -1;
        }
        this.b = pcmListener;
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AlsaJni.pcm_open(card, sampleRate, periodSize, instance);
                Object object = AlsaRecorder.this.e;
                synchronized (object) {
                    AlsaRecorder.this.e.notify();
                }
            }
        };
        Object object = this.e;
        synchronized (object) {
            try {
                thread.start();
                this.e.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        if (pcmHandle != 0) {
            if (-1 == this.d) {
                this.d = AlsaJni.pcm_buffer_size(pcmHandle) / 2;
            }
            if (AlsaJni.pcm_start_record(this.d, this.d * 8) == 0) {
                this.c = true;
            }
            if (this.a == null) {
                this.a = new a();
                this.a.start();
            }
        } else {
            thread.interrupt();
            Log.e((String)"AlsaRecorder", (String)"startRecording | open pcm device failed.");
            return -1;
        }
        return 0;
    }

    public boolean isRecording() {
        return this.c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRecording() {
        if (instance == null) {
            Log.e((String)TAG, (String)"stopRecording | AlsaRecorder instance is null.");
            return;
        }
        if (this.a != null) {
            this.a.a();
            this.a = null;
            Object object = this.e;
            synchronized (object) {
                try {
                    this.e.wait(200L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }

    public int getCardDevId() {
        return card;
    }

    public int getSampleRate() {
        return sampleRate;
    }

    public int getPeriodSize() {
        return periodSize;
    }

    public int getBufferSize() {
        return this.d;
    }

    public PcmListener getListener() {
        return this.b;
    }

    public void destroy() {
        this.stopRecording();
        instance = null;
    }

    public static String getVersion() {
        return "1.3";
    }

    public static interface PcmListener {
        public void onPcmData(byte[] var1, int var2);
    }

    class a
    extends Thread {
        private boolean b;

        public a() {
            super("AlsaRecorder-PcmReadThread");
            this.b = false;
        }

        public void a() {
            this.interrupt();
            this.b = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            super.run();
            while (!this.b) {
                object = new byte[AlsaRecorder.this.d];
                int n2 = AlsaJni.pcm_read(object, ((byte[])object).length);
                if (AlsaRecorder.this.b == null || n2 == 0) continue;
                AlsaRecorder.this.b.onPcmData((byte[])object, ((byte[])object).length);
            }
            AlsaJni.pcm_close(pcmHandle);
            AlsaRecorder.this.c = false;
            pcmHandle = 0;
            Object object2 = AlsaRecorder.this.e;
            object = object2;
            synchronized (object2) {
                AlsaRecorder.this.e.notify();
                // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
                return;
            }
        }
    }
}

