/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.sdk.platformtools;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import com.tencent.mm.sdk.platformtools.Log;
import com.tencent.mm.sdk.platformtools.SystemProperty;
import com.tencent.mm.sdk.platformtools.Util;
import java.util.Locale;

public final class LocaleUtil {
    public static final String LANGUAGE_DEFAULT = "language_default";
    public static final String LANGUAGE_KEY = "language_key";
    public static final String TAIWAN = "zh_TW";
    public static final String HONGKONG = "zh_HK";
    public static final String CHINA = "zh_CN";
    public static final String ENGLISH = "en";
    public static final String THAI = "th";
    public static final String INDONESIAN = "id";
    public static final String VIETNAMESE = "vi";
    public static final String PORTUGUESE = "pt";
    public static final String SPANISH = "es";
    public static final String RUSSIAN = "ru";
    public static final String ARABIC = "ar";
    public static final String HEBREW = "iw";
    public static final String POLISH = "pl";
    public static final String HINDI = "hi";
    public static final String JAPANESE = "ja";
    public static final String ITALIAN = "it";
    public static final String KOREAN = "ko";
    public static final String MALAY = "ms";
    public static final String TURKEY = "tr";

    private LocaleUtil() {
    }

    public static boolean isLanguageSupported(String string) {
        if (Util.isNullOrNil(string)) {
            return false;
        }
        return string.equalsIgnoreCase(TAIWAN) || string.equalsIgnoreCase(HONGKONG) || string.equalsIgnoreCase(CHINA) || string.equalsIgnoreCase(ENGLISH) || string.equalsIgnoreCase(THAI) || string.equals(INDONESIAN) || string.equals(VIETNAMESE) || string.equalsIgnoreCase(PORTUGUESE) || string.equalsIgnoreCase(SPANISH) || string.equalsIgnoreCase(RUSSIAN) || string.equalsIgnoreCase(ARABIC) || string.equalsIgnoreCase(HEBREW) || string.equalsIgnoreCase(POLISH) || string.equalsIgnoreCase(HINDI) || string.equalsIgnoreCase(JAPANESE) || string.equalsIgnoreCase(ITALIAN) || string.equalsIgnoreCase(KOREAN) || string.equalsIgnoreCase(MALAY) || string.equalsIgnoreCase(TURKEY);
    }

    public static void updateApplicationResourceLocale(Context context, Locale locale) {
        context = context.getResources();
        Configuration configuration = context.getConfiguration();
        if (configuration.locale.equals(locale)) {
            return;
        }
        DisplayMetrics displayMetrics = context.getDisplayMetrics();
        configuration.locale = locale;
        context.updateConfiguration(configuration, displayMetrics);
        Resources.getSystem().updateConfiguration(configuration, displayMetrics);
    }

    public static Locale transLanguageToLocale(String string) {
        if (string.equals(TAIWAN) || string.equals(HONGKONG)) {
            return Locale.TAIWAN;
        }
        if (string.equals(ENGLISH)) {
            return Locale.ENGLISH;
        }
        if (string.equals(CHINA)) {
            return Locale.CHINA;
        }
        if (string.equalsIgnoreCase(THAI)) {
            return new Locale(string);
        }
        if (string.equalsIgnoreCase(INDONESIAN)) {
            return new Locale(string);
        }
        if (string.equalsIgnoreCase(VIETNAMESE)) {
            return new Locale(string);
        }
        if (string.equalsIgnoreCase(PORTUGUESE)) {
            return new Locale(string);
        }
        if (string.equalsIgnoreCase(SPANISH)) {
            return new Locale(string);
        }
        if (string.equalsIgnoreCase(RUSSIAN)) {
            return new Locale(string);
        }
        if (string.equalsIgnoreCase(ARABIC)) {
            return new Locale(string);
        }
        if (string.equalsIgnoreCase(HEBREW)) {
            return new Locale(string);
        }
        if (string.equalsIgnoreCase(POLISH)) {
            return new Locale(string);
        }
        if (string.equalsIgnoreCase(HINDI)) {
            return new Locale(string);
        }
        if (string.equalsIgnoreCase(JAPANESE)) {
            return new Locale(string);
        }
        if (string.equalsIgnoreCase(ITALIAN)) {
            return new Locale(string);
        }
        if (string.equalsIgnoreCase(KOREAN)) {
            return new Locale(string);
        }
        if (string.equalsIgnoreCase(MALAY)) {
            return new Locale(string);
        }
        if (string.equalsIgnoreCase(TURKEY)) {
            return new Locale(string);
        }
        Log.e("MicroMsg.LocaleUtil", "transLanguageToLocale country = " + string);
        return Locale.ENGLISH;
    }

    public static String getCurrentCountryCode() {
        return Locale.getDefault().getCountry().trim();
    }

    private static String b(String string) {
        String string2 = Locale.getDefault().getLanguage().trim();
        if (string2.equals(ENGLISH)) {
            return string2;
        }
        string2 = Locale.getDefault().getLanguage().trim() + "_" + Locale.getDefault().getCountry().trim();
        if (string2.equals(TAIWAN) || string2.equals(HONGKONG)) {
            return TAIWAN;
        }
        if ((Locale.getDefault().getLanguage().trim() + "_" + Locale.getDefault().getCountry().trim()).equals(CHINA)) {
            return CHINA;
        }
        if (Locale.getDefault().getLanguage().trim().equals(THAI)) {
            return THAI;
        }
        if (Locale.getDefault().getLanguage().trim().equals(INDONESIAN)) {
            return INDONESIAN;
        }
        if (Locale.getDefault().getLanguage().trim().equals(VIETNAMESE)) {
            return VIETNAMESE;
        }
        if (Locale.getDefault().getLanguage().trim().equals(PORTUGUESE)) {
            return PORTUGUESE;
        }
        if (Locale.getDefault().getLanguage().trim().equals(SPANISH)) {
            return SPANISH;
        }
        if (Locale.getDefault().getLanguage().trim().equals(RUSSIAN)) {
            return RUSSIAN;
        }
        if (Locale.getDefault().getLanguage().trim().equals(ARABIC)) {
            return ARABIC;
        }
        if (Locale.getDefault().getLanguage().trim().equals(HEBREW)) {
            return HEBREW;
        }
        if (Locale.getDefault().getLanguage().trim().equals(POLISH)) {
            return POLISH;
        }
        if (Locale.getDefault().getLanguage().trim().equals(HINDI)) {
            return HINDI;
        }
        if (Locale.getDefault().getLanguage().trim().equals(JAPANESE)) {
            return JAPANESE;
        }
        if (Locale.getDefault().getLanguage().trim().equals(ITALIAN)) {
            return ITALIAN;
        }
        if (Locale.getDefault().getLanguage().trim().equals(KOREAN)) {
            return KOREAN;
        }
        if (Locale.getDefault().getLanguage().trim().equals(MALAY)) {
            return MALAY;
        }
        if (Locale.getDefault().getLanguage().trim().equals(TURKEY)) {
            return TURKEY;
        }
        return string;
    }

    public static String getApplicationLanguage() {
        String string = Util.nullAsNil(SystemProperty.getProperty(LANGUAGE_KEY));
        if (string.length() > 0 && !string.equals(LANGUAGE_DEFAULT)) {
            return string;
        }
        return LocaleUtil.b(ENGLISH);
    }

    public static String loadApplicationLanguage(SharedPreferences object, Context context) {
        if (((String)(object = Util.nullAsNil(object.getString(LANGUAGE_KEY, null)))).length() > 0 && !((String)object).equals(LANGUAGE_DEFAULT)) {
            SystemProperty.setProperty(LANGUAGE_KEY, (String)object);
            return object;
        }
        object = LocaleUtil.b(ENGLISH);
        SystemProperty.setProperty(LANGUAGE_KEY, (String)object);
        return object;
    }

    public static String loadApplicationLanguageSettings(SharedPreferences object, Context context) {
        if (!Util.isNullOrNil((String)(object = Util.nullAsNil(object.getString(LANGUAGE_KEY, null))))) {
            return object;
        }
        return LANGUAGE_DEFAULT;
    }

    public static void saveApplicationLanguage(SharedPreferences sharedPreferences, Context context, String string) {
        if (sharedPreferences.edit().putString(LANGUAGE_KEY, string).commit()) {
            SystemProperty.setProperty(LANGUAGE_KEY, string);
            Log.w("MicroMsg.LocaleUtil", "save application lang as:" + string);
            return;
        }
        Log.e("MicroMsg.LocaleUtil", "saving application lang failed");
    }
}

