/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.sdk.plugin;

import android.content.Context;
import android.content.Intent;
import com.tencent.mm.sdk.openapi.BaseReq;
import com.tencent.mm.sdk.openapi.SendMessageToWX;
import com.tencent.mm.sdk.openapi.WXAPIFactory;
import com.tencent.mm.sdk.openapi.WXAppExtendObject;
import com.tencent.mm.sdk.openapi.WXMediaMessage;
import com.tencent.mm.sdk.platformtools.Util;

public class MMPluginMsg {
    public long msgClientId;
    public String content;
    public static final String ACTION_AUTO_MSG = "ACTION_AUTO_MSG";
    public static final String RECV_PKG = "recv_pkg";
    public static final String RECV_MSG = "recv_msg";
    public static final String RECV_THUMB = "recv_thumb";
    public static final String SEND_ID = "send_id";
    public static final String SEND_ERR_TYPE = "send_err_type";
    public static final String SEND_ERR_CODE = "send_err_code";
    public static final String TYPE = "type";
    public static final int TYPE_SEND_RET = 1;
    public static final int TYPE_RECV_MSG = 2;

    public static WXAppExtendObject pluginMsgToWXAppExtendObject(MMPluginMsg mMPluginMsg) {
        if (mMPluginMsg == null) {
            return null;
        }
        WXAppExtendObject wXAppExtendObject = new WXAppExtendObject();
        new WXAppExtendObject().extInfo = "" + mMPluginMsg.msgClientId;
        wXAppExtendObject.fileData = mMPluginMsg.content.getBytes();
        return wXAppExtendObject;
    }

    public static MMPluginMsg WXAppExtentObjectToPluginMsg(WXAppExtendObject wXAppExtendObject) {
        if (wXAppExtendObject == null) {
            return null;
        }
        MMPluginMsg mMPluginMsg = new MMPluginMsg();
        new MMPluginMsg().msgClientId = Util.getLong(wXAppExtendObject.extInfo, -1L);
        if (mMPluginMsg.msgClientId == -1L) {
            return null;
        }
        if (Util.isNullOrNil(wXAppExtendObject.fileData)) {
            return null;
        }
        mMPluginMsg.content = new String(wXAppExtendObject.fileData);
        if (Util.isNullOrNil(mMPluginMsg.content)) {
            return null;
        }
        return mMPluginMsg;
    }

    public static long sendMessage(Context object, String object2) {
        if (Util.isNullOrNil((String)object2)) {
            return -1L;
        }
        MMPluginMsg mMPluginMsg = new MMPluginMsg();
        new MMPluginMsg().msgClientId = Util.nowMilliSecond();
        mMPluginMsg.content = object2;
        object2 = MMPluginMsg.pluginMsgToWXAppExtendObject(mMPluginMsg);
        WXMediaMessage wXMediaMessage = new WXMediaMessage();
        new WXMediaMessage().mediaObject = object2;
        wXMediaMessage.description = "";
        if ((object = WXAPIFactory.createWXAPI((Context)object, null)) == null) {
            return -2L;
        }
        object2 = new SendMessageToWX.Req();
        new SendMessageToWX.Req().transaction = "appdata" + mMPluginMsg.msgClientId;
        ((SendMessageToWX.Req)object2).message = wXMediaMessage;
        if (!object.sendReq((BaseReq)object2)) {
            return -3L;
        }
        return mMPluginMsg.msgClientId;
    }

    public static class ReceiverHelper {
        int type;
        Intent intent;

        public ReceiverHelper(Intent intent) {
            this.type = intent.getIntExtra(MMPluginMsg.TYPE, 0);
            this.intent = intent;
        }

        public boolean isSendRet() {
            return this.type == 1;
        }

        public boolean isRecvNew() {
            return this.type == 2;
        }

        public String getMsgContent() {
            if (this.isRecvNew()) {
                return this.intent.getStringExtra(MMPluginMsg.RECV_MSG);
            }
            return null;
        }

        public Integer getSendErrCode() {
            if (this.isSendRet()) {
                return this.intent.getIntExtra(MMPluginMsg.SEND_ERR_CODE, 0);
            }
            return null;
        }

        public Integer getSendErrType() {
            if (this.isSendRet()) {
                return this.intent.getIntExtra(MMPluginMsg.SEND_ERR_TYPE, 0);
            }
            return null;
        }

        public Long getSendMsgId() {
            if (this.isSendRet()) {
                return this.intent.getLongExtra(MMPluginMsg.SEND_ID, 0L);
            }
            return null;
        }
    }
}

