/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.sdk.platformtools;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import com.tencent.mm.sdk.platformtools.KVConfig;
import com.tencent.mm.sdk.platformtools.Log;
import com.tencent.mm.sdk.platformtools.MMApplicationContext;
import com.tencent.mm.sdk.platformtools.Util;

public final class ChannelUtil {
    public static final int FLAG_UPDATE_EXTERNAL = 1;
    public static final int FLAG_UPDATE_NOTIP = 2;
    public static final int FLAG_NULL = 0;
    public static int channelId = 0;
    public static String profileDeviceType = "" + Build.VERSION.SDK_INT;
    public static int updateMode = 0;
    public static int buildRev = 0;
    public static String marketURL = "market://details?id=" + MMApplicationContext.getPackageName();
    public static boolean fullVersionInfo = false;

    private ChannelUtil() {
    }

    public static void setupChannelId(Context context) {
        try {
            String string = Util.convertStreamToString(context.getAssets().open("channel.ini"));
            context = null;
            channelId = Integer.parseInt(KVConfig.parseIni(string).get("CHANNEL"));
            return;
        }
        catch (Exception exception) {
            Log.e("MicroMsg.SDK.ChannelUtil", "setup channel id from channel.ini failed");
            exception.printStackTrace();
            return;
        }
    }

    public static void loadProfile(Context object) {
        try {
            String string = Util.convertStreamToString(object.getAssets().open("profile.ini"));
            object = null;
            object = KVConfig.parseIni(string);
            profileDeviceType = Util.nullAsNil(object.get("PROFILE_DEVICE_TYPE"));
            if (profileDeviceType.length() <= 0) {
                profileDeviceType = "" + Build.VERSION.SDK_INT;
            }
            updateMode = Integer.parseInt((String)object.get("UPDATE_MODE"));
            buildRev = Integer.parseInt((String)object.get("BUILD_REVISION"));
            android.util.Log.w((String)"MicroMsg.SDK.ChannelUtil", (String)("profileDeviceType=" + profileDeviceType));
            android.util.Log.w((String)"MicroMsg.SDK.ChannelUtil", (String)("updateMode=" + updateMode));
            object = (String)object.get("MARKET_URL");
            if (object != null && ((String)object).trim().length() != 0 && Uri.parse((String)object) != null) {
                marketURL = object;
            }
            android.util.Log.w((String)"MicroMsg.SDK.ChannelUtil", (String)("marketURL=" + marketURL));
            return;
        }
        catch (Exception exception) {
            android.util.Log.e((String)"MicroMsg.SDK.ChannelUtil", (String)"setup profile from profile.ini failed");
            exception.printStackTrace();
            return;
        }
    }

    public static String formatVersion(Context object, int n) {
        String string = (n >> 24 & 0xF) + "." + (n >> 16 & 0xFF);
        n &= 0xFFFF;
        if (object != null) {
            try {
                object = object.getPackageManager().getPackageInfo(object.getPackageName(), 128);
                if (object != null) {
                    n = object.versionCode;
                    string = object.versionName;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (fullVersionInfo) {
            object = string + " r" + n + "(build." + buildRev + ")";
            Log.d("MicroMsg.SDK.ChannelUtil", "full version: " + (String)object);
            return object;
        }
        return string;
    }
}

