/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.sdk.platformtools;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Pattern;

public final class InetUtil {
    private static final Pattern X = Pattern.compile("^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$");
    private static final Pattern Y = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
    private static final Pattern Z = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$");

    private InetUtil() {
    }

    public static boolean isIPv4Address(String string) {
        return X.matcher(string).matches();
    }

    public static boolean isIPv6StdAddress(String string) {
        return Y.matcher(string).matches();
    }

    public static boolean isIPv6HexCompressedAddress(String string) {
        return Z.matcher(string).matches();
    }

    public static boolean isIPv6Address(String string) {
        return InetUtil.isIPv6StdAddress(string) || InetUtil.isIPv6HexCompressedAddress(string);
    }

    public static InetAddress getByDottedAddress(String string) {
        if (InetUtil.isIPv4Address(string)) {
            return InetAddress.getByName(string);
        }
        if (InetUtil.isIPv6Address(string)) {
            return InetAddress.getByName(string);
        }
        throw new UnknownHostException("invalid ipv4 or ipv6 dotted string");
    }
}

