/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.sdk.platformtools;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.Location;
import android.location.LocationManager;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiManager;
import com.tencent.mm.sdk.platformtools.Log;
import com.tencent.mm.sdk.platformtools.MTimerHandler;
import com.tencent.mm.sdk.platformtools.PhoneUtil;
import com.tencent.mm.sdk.platformtools.Util;
import java.util.LinkedList;

public class LBSManager
extends BroadcastReceiver {
    public static final String FILTER_GPS = "filter_gps";
    public static final float INVALID_LAT = -1000.0f;
    public static final float INVALID_LNG = -1000.0f;
    public static final int INVALID_ACC = -1000;
    public static final int MM_SOURCE_HARDWARE = 0;
    public static final int MM_SOURCE_NET = 1;
    public static final int MM_SOURCE_REPORT_HARWARE = 3;
    public static final int MM_SOURCE_REPORT_NETWORK = 4;
    private static LocationCache ab;
    private OnLocationGotListener ac;
    private LocationManager ad;
    private Context R;
    private PendingIntent ae;
    private boolean af = false;
    boolean ag;
    boolean ah = false;
    boolean ai = false;
    int aj;
    private MTimerHandler ak = new MTimerHandler(new MTimerHandler.CallBack(){

        public boolean onTimerExpired() {
            Log.v("MicroMsg.LBSManager", "get location by GPS failed.");
            LBSManager.this.ag = true;
            LBSManager.this.start();
            LBSManager.a(LBSManager.this);
            return false;
        }
    }, false);

    public LBSManager(Context context, OnLocationGotListener onLocationGotListener) {
        this.ac = onLocationGotListener;
        this.ag = false;
        this.aj = 0;
        this.R = context;
        PhoneUtil.getSignalStrength(context);
        this.ad = (LocationManager)context.getSystemService("location");
        this.b();
        this.ae = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(FILTER_GPS), (int)0x8000000);
    }

    private boolean b() {
        if (this.ad != null) {
            try {
                this.ad.sendExtraCommand("gps", "force_xtra_injection", null);
                this.ad.sendExtraCommand("gps", "force_time_injection", null);
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }
        return false;
    }

    public void start() {
        String string = Util.nullAsNil(this.getWIFILocation());
        String string2 = Util.nullAsNil(this.getTelLocation());
        if ((this.isGpsEnable() || this.isNetworkPrividerEnable()) && !this.af) {
            this.af = true;
            this.aj = 0;
            this.requestGpsUpdate();
            this.ak.startTimer(3000L);
            return;
        }
        if (ab == null ? false : System.currentTimeMillis() - LBSManager.ab.time <= 180000L && LBSManager.ab.ao > 0) {
            if (this.ac != null) {
                this.ag = true;
                Log.v("MicroMsg.LBSManager", "location by GPS cache ok:[" + LBSManager.ab.am + " , " + LBSManager.ab.an + "]  accuracy:" + LBSManager.ab.ao + " source:" + LBSManager.ab.I);
                this.ac.onLocationGot(LBSManager.ab.am, LBSManager.ab.an, LBSManager.ab.ao, LBSManager.ab.I, string, string2, true);
                return;
            }
        } else {
            this.ag = true;
            if (string.equals("") && string2.equals("")) {
                Log.v("MicroMsg.LBSManager", "get location by network failed");
                if (this.ac != null) {
                    this.ac.onLocationGot(-1000.0f, -1000.0f, -1000, 0, "", "", false);
                    return;
                }
            } else {
                Log.v("MicroMsg.LBSManager", "get location by network ok, macs : " + string + " cell ids :" + string2);
                if (this.ac != null) {
                    this.ac.onLocationGot(-1000.0f, -1000.0f, -1000, 0, string, string2, true);
                }
            }
        }
    }

    public boolean isGpsEnable() {
        try {
            return this.ad.isProviderEnabled("gps");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean isNetworkPrividerEnable() {
        try {
            return this.ad.isProviderEnabled("network");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void removeGpsUpdate() {
        Log.v("MicroMsg.LBSManager", "removed gps update");
        if (this.ad != null) {
            this.ad.removeUpdates(this.ae);
        }
        try {
            this.R.unregisterReceiver((BroadcastReceiver)this);
            return;
        }
        catch (Exception exception) {
            Log.v("MicroMsg.LBSManager", "location receiver has already unregistered");
            return;
        }
    }

    public void requestGpsUpdate() {
        if (!this.isGpsEnable() && !this.isNetworkPrividerEnable()) {
            return;
        }
        Log.v("MicroMsg.LBSManager", "requested gps update");
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(FILTER_GPS);
        this.R.registerReceiver((BroadcastReceiver)this, intentFilter);
        if (this.isGpsEnable()) {
            this.ad.requestLocationUpdates("gps", 500L, 0.0f, this.ae);
        }
        if (this.isNetworkPrividerEnable()) {
            this.ad.requestLocationUpdates("network", 500L, 0.0f, this.ae);
        }
    }

    public void removeListener() {
        Log.v("MicroMsg.LBSManager", "removed gps update on destroy");
        this.removeGpsUpdate();
        if (this.ak != null) {
            this.c();
        }
        this.ac = null;
        this.R = null;
        this.ak = null;
        this.ad = null;
    }

    private void c() {
        this.ak.stopTimer();
        this.ag = true;
    }

    public String getTelLocation() {
        return PhoneUtil.getCellXml(PhoneUtil.getCellInfoList(this.R));
    }

    public String getWIFILocation() {
        Object object = (WifiManager)this.R.getSystemService("wifi");
        if (object == null) {
            Log.e("MicroMsg.LBSManager", "no wifi service");
            return "";
        }
        if (object.getConnectionInfo() == null) {
            Log.e("MicroMsg.LBSManager", "WIFILocation wifi info null");
            return "";
        }
        LinkedList<PhoneUtil.MacInfo> linkedList = new LinkedList<PhoneUtil.MacInfo>();
        if ((object = object.getScanResults()) != null) {
            for (int i = 0; i < object.size(); ++i) {
                PhoneUtil.MacInfo macInfo = new PhoneUtil.MacInfo(((ScanResult)object.get((int)i)).BSSID, "" + ((ScanResult)object.get((int)i)).level);
                linkedList.add(macInfo);
            }
        }
        return PhoneUtil.getMacXml(linkedList);
    }

    public static void setLocationCache(float f, float f2, int n, int n2) {
        if (n == 0) {
            return;
        }
        Log.v("MicroMsg.LBSManager", "setLocationCache [" + f + "," + f2 + "] acc:" + n + " source:" + n2);
        if (ab == null) {
            ab = new LocationCache();
        }
        LBSManager.ab.am = f;
        LBSManager.ab.an = f2;
        LBSManager.ab.ao = n;
        LBSManager.ab.time = System.currentTimeMillis();
        LBSManager.ab.I = n2;
    }

    public void onReceive(Context context, Intent intent) {
        boolean bl;
        context = (Location)intent.getExtras().get("location");
        ++this.aj;
        if (context != null && ((bl = "gps".equals(context.getProvider())) && context.getAccuracy() <= 200.0f || !bl && context.getAccuracy() <= 1000.0f) && context.getAccuracy() > 0.0f) {
            int n = bl ? 0 : 1;
            LBSManager.setLocationCache((float)context.getLatitude(), (float)context.getLongitude(), (int)context.getAccuracy(), n);
            if (!(this.ac == null || this.ag && this.ah && this.ai)) {
                String string = Util.nullAsNil(this.getWIFILocation());
                String string2 = Util.nullAsNil(this.getTelLocation());
                if (!this.ag) {
                    this.c();
                    this.ag = true;
                    Log.v("MicroMsg.LBSManager", "location by provider ok:[" + context.getLatitude() + " , " + context.getLongitude() + "]  accuracy:" + context.getAccuracy() + "  retry count:" + this.aj + " isGpsProvider:" + bl);
                    this.ac.onLocationGot((float)context.getLatitude(), (float)context.getLongitude(), (int)context.getAccuracy(), n, string, string2, true);
                    return;
                }
                if (!this.ah && n == 0) {
                    this.ah = true;
                    Log.v("MicroMsg.LBSManager", "report location by GPS ok:[" + context.getLatitude() + " , " + context.getLongitude() + "]  accuracy:" + context.getAccuracy() + "  retry count:" + this.aj + " isGpsProvider:" + bl);
                    this.ac.onLocationGot((float)context.getLatitude(), (float)context.getLongitude(), (int)context.getAccuracy(), 3, string, string2, true);
                    return;
                }
                if (!this.ai && n == 1) {
                    this.ai = true;
                    Log.v("MicroMsg.LBSManager", "report location by Network ok:[" + context.getLatitude() + " , " + context.getLongitude() + "]  accuracy:" + context.getAccuracy() + "  retry count:" + this.aj + " isGpsProvider:" + bl);
                    this.ac.onLocationGot((float)context.getLatitude(), (float)context.getLongitude(), (int)context.getAccuracy(), 4, string, string2, true);
                    return;
                }
            }
        }
    }

    static /* synthetic */ boolean a(LBSManager lBSManager) {
        lBSManager.af = false;
        return false;
    }

    static class LocationCache {
        float am = -1000.0f;
        float an = -1000.0f;
        int ao = -1000;
        long time;
        int I = 1;

        LocationCache() {
        }
    }

    public static interface OnLocationGotListener {
        public void onLocationGot(float var1, float var2, int var3, int var4, String var5, String var6, boolean var7);
    }
}

