/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.sdk.platformtools;

import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.ConnectivityManager;
import android.os.Build;
import android.provider.Settings;
import com.tencent.mm.sdk.platformtools.Log;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;

public class NetStatusUtil {
    public static final int NON_NETWORK = -1;
    public static final int WIFI = 0;
    public static final int UNINET = 1;
    public static final int UNIWAP = 2;
    public static final int WAP_3G = 3;
    public static final int NET_3G = 4;
    public static final int CMWAP = 5;
    public static final int CMNET = 6;
    public static final int CTWAP = 7;
    public static final int CTNET = 8;
    public static final int MOBILE = 9;
    public static final int LTE = 10;
    public static final int POLICY_NONE = 0;
    public static final int POLICY_REJECT_METERED_BACKGROUND = 1;
    public static final int TBACKGROUND_NOT_LIMITED = 0;
    public static final int TBACKGROUND_PROCESS_LIMITED = 1;
    public static final int TBACKGROUND_DATA_LIMITED = 2;
    public static final int TBACKGROUND_WIFI_LIMITED = 3;

    public static void dumpNetStatus(Context context) {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            context = null;
            context = connectivityManager.getActiveNetworkInfo();
            Log.e("MicroMsg.NetStatusUtil", "isAvailable " + context.isAvailable());
            Log.e("MicroMsg.NetStatusUtil", "isConnected " + context.isConnected());
            Log.e("MicroMsg.NetStatusUtil", "isRoaming " + context.isRoaming());
            Log.e("MicroMsg.NetStatusUtil", "isFailover " + context.isFailover());
            Log.e("MicroMsg.NetStatusUtil", "getSubtypeName " + context.getSubtypeName());
            Log.e("MicroMsg.NetStatusUtil", "getExtraInfo " + context.getExtraInfo());
            Log.e("MicroMsg.NetStatusUtil", "activeNetInfo " + context.toString());
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public static boolean isConnected(Context context) {
        context = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo();
        boolean bl = false;
        try {
            bl = context.isConnected();
        }
        catch (Exception exception) {}
        return bl;
    }

    public static String getNetTypeString(Context context) {
        if ((context = (ConnectivityManager)context.getSystemService("connectivity")) == null) {
            return "NON_NETWORK";
        }
        if ((context = context.getActiveNetworkInfo()) == null) {
            return "NON_NETWORK";
        }
        if (context.getType() == 1) {
            return "WIFI";
        }
        Log.d("MicroMsg.NetStatusUtil", "activeNetInfo.getExtraInfo()  " + context.getExtraInfo());
        Log.d("MicroMsg.NetStatusUtil", "activeNetInfo.getType()  " + context.getType());
        if (context.getExtraInfo() != null) {
            return context.getExtraInfo();
        }
        return "MOBILE";
    }

    public static int getNetType(Context context) {
        if ((context = (ConnectivityManager)context.getSystemService("connectivity")) == null) {
            return -1;
        }
        if ((context = context.getActiveNetworkInfo()) == null) {
            return -1;
        }
        if (context.getType() == 1) {
            return 0;
        }
        Log.d("MicroMsg.NetStatusUtil", "activeNetInfo.getExtraInfo()  " + context.getExtraInfo());
        Log.d("MicroMsg.NetStatusUtil", "activeNetInfo.getType()  " + context.getType());
        if (context.getExtraInfo() != null) {
            if (context.getExtraInfo().equals("uninet")) {
                return 1;
            }
            if (context.getExtraInfo().equals("uniwap")) {
                return 2;
            }
            if (context.getExtraInfo().equals("3gwap")) {
                return 3;
            }
            if (context.getExtraInfo().equals("3gnet")) {
                return 4;
            }
            if (context.getExtraInfo().equals("cmwap")) {
                return 5;
            }
            if (context.getExtraInfo().equals("cmnet")) {
                return 6;
            }
            if (context.getExtraInfo().equals("ctwap")) {
                return 7;
            }
            if (context.getExtraInfo().equals("ctnet")) {
                return 8;
            }
            if (context.getExtraInfo().equals("LTE")) {
                return 10;
            }
        }
        return 9;
    }

    public static boolean is2G(Context context) {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            context = null;
            context = connectivityManager.getActiveNetworkInfo();
            if (context.getType() == 1) {
                return false;
            }
            if (context.getSubtype() == 2 || context.getSubtype() == 1) {
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public static boolean is4G(Context context) {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            context = null;
            context = connectivityManager.getActiveNetworkInfo();
            if (context.getType() == 1) {
                return false;
            }
            if (context.getSubtype() >= 13) {
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public static boolean isWap(Context context) {
        return NetStatusUtil.isWap(NetStatusUtil.getNetType(context));
    }

    public static boolean isWap(int n) {
        return n == 2 || n == 5 || n == 7 || n == 3;
    }

    public static boolean is2G(int n) {
        return n == 1 || n == 2 || n == 5 || n == 6 || n == 7 || n == 8;
    }

    public static boolean is4G(int n) {
        return n == 10;
    }

    public static boolean is3G(int n) {
        return n == 3 || n == 4;
    }

    public static boolean isMobile(Context context) {
        int n = NetStatusUtil.getNetType(context);
        return NetStatusUtil.is3G(n) || NetStatusUtil.is2G(n) || NetStatusUtil.is4G(n);
    }

    public static boolean isMobile(int n) {
        return NetStatusUtil.is3G(n) || NetStatusUtil.is2G(n) || NetStatusUtil.is4G(n);
    }

    public static boolean is3G(Context context) {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            context = null;
            context = connectivityManager.getActiveNetworkInfo();
            if (context.getType() == 1) {
                return false;
            }
            if (context.getSubtype() >= 5 && context.getSubtype() < 13) {
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public static boolean isWifi(Context context) {
        return NetStatusUtil.isWifi(NetStatusUtil.getNetType(context));
    }

    public static boolean isWifi(int n) {
        return n == 0;
    }

    private static Intent a(Context context, String string) {
        try {
            PackageManager packageManager = context.getPackageManager();
            List list = packageManager.getInstalledPackages(0);
            if (list != null && list.size() > 0) {
                Log.e("MicroMsg.NetStatusUtil", "package  size" + list.size());
                for (int i = 0; i < list.size(); ++i) {
                    Object object;
                    try {
                        Log.e("MicroMsg.NetStatusUtil", "package " + ((PackageInfo)list.get((int)i)).packageName);
                        object = new Intent();
                        object.setPackage(((PackageInfo)list.get((int)i)).packageName);
                        object = packageManager.queryIntentActivities((Intent)object, 0);
                        int n = object != null ? object.size() : 0;
                        if (n <= 0) continue;
                        try {
                            Log.e("MicroMsg.NetStatusUtil", "activityName count " + n);
                            for (int j = 0; j < n; ++j) {
                                ActivityInfo activityInfo = ((ResolveInfo)object.get((int)j)).activityInfo;
                                if (!activityInfo.name.contains(string)) continue;
                                object = new Intent("/");
                                ComponentName componentName = new ComponentName(activityInfo.packageName, activityInfo.name);
                                object.setComponent(componentName);
                                object.setAction("android.intent.action.VIEW");
                                context.startActivity((Intent)object);
                                return object;
                            }
                            continue;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            continue;
                        }
                    }
                    catch (Exception exception) {
                        object = null;
                        exception.printStackTrace();
                    }
                }
            }
        }
        catch (Exception exception) {
            Object var2_3 = null;
            exception.printStackTrace();
        }
        return null;
    }

    public static void startSettingItent(Context context, int n) {
        switch (n) {
            case 0: {
                return;
            }
            case 2: {
                try {
                    Intent intent = new Intent("/");
                    ComponentName componentName = new ComponentName("com.android.providers.subscribedfeeds", "com.android.settings.ManageAccountsSettings");
                    intent.setComponent(componentName);
                    intent.setAction("android.intent.action.VIEW");
                    context.startActivity(intent);
                    return;
                }
                catch (Exception exception) {
                    try {
                        Intent intent = new Intent("/");
                        ComponentName componentName = new ComponentName("com.htc.settings.accountsync", "com.htc.settings.accountsync.ManageAccountsSettings");
                        intent.setComponent(componentName);
                        intent.setAction("android.intent.action.VIEW");
                        context.startActivity(intent);
                        return;
                    }
                    catch (Exception exception2) {
                        NetStatusUtil.a(context, "ManageAccountsSettings");
                        return;
                    }
                }
            }
            case 1: {
                try {
                    Intent intent = new Intent("/");
                    ComponentName componentName = new ComponentName("com.android.settings", "com.android.settings.DevelopmentSettings");
                    intent.setComponent(componentName);
                    intent.setAction("android.intent.action.VIEW");
                    context.startActivity(intent);
                    return;
                }
                catch (Exception exception) {
                    NetStatusUtil.a(context, "DevelopmentSettings");
                    return;
                }
            }
            case 3: {
                try {
                    Intent intent = new Intent();
                    intent.setAction("android.settings.WIFI_IP_SETTINGS");
                    context.startActivity(intent);
                    return;
                }
                catch (Exception exception) {
                    NetStatusUtil.a(context, "AdvancedSettings");
                }
            }
        }
    }

    public static int getWifiSleeepPolicy(Context context) {
        return Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"wifi_sleep_policy", (int)2);
    }

    public static boolean isLimited(int n) {
        return n == 2 || n == 1 || n == 3;
    }

    public static int getBackgroundLimitType(Context context) {
        if (Build.VERSION.SDK_INT >= 14) {
            try {
                Object object = Class.forName("android.app.ActivityManagerNative");
                object = ((Class)object).getMethod("getDefault", new Class[0]).invoke(object, new Object[0]);
                if ((Integer)object.getClass().getMethod("getProcessLimit", new Class[0]).invoke(object, new Object[0]) == 0) {
                    return 1;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            int n = NetStatusUtil.getWifiSleeepPolicy(context);
            if (n == 2) {
                return 0;
            }
            if (n == 1 || n == 0) {
                return 3;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return 0;
    }

    public static boolean isRestrictBacground(Context object) {
        int n = object.getApplicationInfo().uid;
        try {
            AnnotatedElement annotatedElement = Class.forName("android.net.NetworkPolicyManager");
            object = ((Class)annotatedElement).getMethod("getSystemService", Context.class).invoke(annotatedElement, object);
            annotatedElement = ((Class)annotatedElement).getDeclaredField("mService");
            ((Field)annotatedElement).setAccessible(true);
            object = ((Field)annotatedElement).get(object);
            int n2 = (Integer)object.getClass().getMethod("getUidPolicy", Integer.TYPE).invoke(object, n);
            Log.e("MicroMsg.NetStatusUtil", "policy is " + n2);
            if (n2 == 1) {
                return true;
            }
            if (n2 == 0) {
                return false;
            }
        }
        catch (Exception exception) {
            Object var2_4 = null;
            exception.printStackTrace();
        }
        return NetStatusUtil.checkFromXml(n);
    }

    public static boolean isImmediatelyDestroyActivities(Context context) {
        return Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"always_finish_activities", (int)0) != 0;
    }

    public static boolean checkFromXml(int n) {
        try {
            NetStatusUtil.runRootCommand();
            Object object = null;
            object = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            FileInputStream fileInputStream = new FileInputStream(new File("/data/system/netpolicy.xml"));
            object = ((DocumentBuilder)object).parse(fileInputStream).getDocumentElement().getElementsByTagName("uid-policy");
            for (int i = 0; i < object.getLength(); ++i) {
                Object object2 = (Element)object.item(i);
                String string = object2.getAttribute("uid");
                object2 = object2.getAttribute("policy");
                Log.e("MicroMsg.NetStatusUtil", "uid is " + string + "  policy is " + (String)object2);
                if (!string.equals(Integer.toString(n))) continue;
                if (Integer.parseInt((String)object2) == 1) {
                    return true;
                }
                if (Integer.parseInt((String)object2) != 0) continue;
                return false;
            }
        }
        catch (Exception exception) {
            Object var1_2 = null;
            exception.printStackTrace();
        }
        return false;
    }

    /*
     * Loose catch block
     */
    public static boolean runRootCommand() {
        block15: {
            Process process = null;
            FilterOutputStream filterOutputStream = null;
            process = Runtime.getRuntime().exec("su");
            filterOutputStream = new DataOutputStream(process.getOutputStream());
            ((DataOutputStream)filterOutputStream).writeBytes("exit\n");
            ((DataOutputStream)filterOutputStream).flush();
            process.waitFor();
            try {
                filterOutputStream.close();
                if (process != null) {
                    process.destroy();
                }
                break block15;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break block15;
            catch (Exception exception) {
                try {
                    Log.d("MicroMsg.NetStatusUtil", "the device is not rooted\uff0c error message\uff1a " + exception.getMessage());
                }
                catch (Throwable throwable) {
                    try {
                        if (filterOutputStream != null) {
                            filterOutputStream.close();
                        }
                        if (process != null) {
                            process.destroy();
                        }
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    if (filterOutputStream != null) {
                        filterOutputStream.close();
                    }
                    if (process != null) {
                        process.destroy();
                    }
                }
                catch (Exception exception3) {
                    exception3.printStackTrace();
                }
                return false;
            }
        }
        return true;
    }
}

