/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.sdk.platformtools;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import com.tencent.mm.sdk.platformtools.Log;

public class SensorController
extends BroadcastReceiver
implements SensorEventListener {
    private static float aR = 4.2949673E9f;
    private SensorManager aS;
    private float aT;
    private static float aU = 0.5f;
    private SensorEventCallBack aV;
    private Sensor aW;
    private final boolean aX;
    private boolean aY = false;
    private boolean aZ = false;

    public SensorController(Context context) {
        this.aS = (SensorManager)context.getSystemService("sensor");
        this.aW = this.aS.getDefaultSensor(8);
        this.aX = this.aW != null;
        this.aT = aU + 1.0f;
    }

    public void setSensorCallBack(SensorEventCallBack sensorEventCallBack) {
        Log.v("MicroMsg.SensorController", "sensor callback set");
        if (!this.aZ) {
            this.aS.registerListener((SensorEventListener)this, this.aW, 2);
            this.aZ = true;
        }
        this.aV = sensorEventCallBack;
    }

    public void removeSensorCallBack() {
        Log.v("MicroMsg.SensorController", "sensor callback removed");
        this.aS.unregisterListener((SensorEventListener)this, this.aW);
        this.aS.unregisterListener((SensorEventListener)this);
        this.aZ = false;
        this.aV = null;
    }

    public void onAccuracyChanged(Sensor sensor, int n) {
    }

    public boolean isSensorEnable() {
        return this.aX;
    }

    public void onSensorChanged(SensorEvent sensorEvent) {
        if (this.aY) {
            return;
        }
        float f = sensorEvent.values[0];
        switch (sensorEvent.sensor.getType()) {
            case 8: {
                if (f < aR) {
                    aR = f;
                    aU = aR + 0.5f;
                }
                if (this.aT >= aU && f < aU) {
                    if (this.aV != null) {
                        Log.v("MicroMsg.SensorController", "sensor event false");
                        this.aV.onSensorEvent(false);
                    }
                } else if (this.aT <= aU && f > aU && this.aV != null) {
                    Log.v("MicroMsg.SensorController", "sensor event true");
                    this.aV.onSensorEvent(true);
                }
                this.aT = f;
            }
        }
    }

    public void onReceive(Context context, Intent intent) {
        if (intent.getAction().equals("android.intent.action.HEADSET_PLUG")) {
            int n = intent.getIntExtra("state", 0);
            if (n == 1) {
                this.aY = true;
            }
            if (n == 0) {
                this.aY = false;
            }
        }
    }

    public static interface SensorEventCallBack {
        public void onSensorEvent(boolean var1);
    }
}

