/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.sdk.plugin;

import android.content.ContentValues;
import android.net.Uri;
import android.provider.BaseColumns;
import com.tencent.mm.sdk.platformtools.Log;

public class MMPluginProviderConstants {
    public static final String AUTHORITY = "com.tencent.mm.sdk.plugin.provider";
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_INT = 1;
    public static final int TYPE_LONG = 2;
    public static final int TYPE_STRING = 3;
    public static final int TYPE_BOOLEAN = 4;
    public static final int TYPE_FLOAT = 5;
    public static final int TYPE_DOUBLE = 6;
    public static final String PLUGIN_PACKAGE_PATTERN = "com.tencent.mm.plugin";

    public static class PluginIntent {
        public static final String AUTH_KEY = "com.tencent.mm.sdk.plugin.Intent.AUTHKEY";
        public static final String NAME = "com.tencent.mm.sdk.plugin.Intent.NAME";
        public static final String PACKAGE = "com.tencent.mm.sdk.plugin.Intent.PACKAGE";
        public static final String REQUEST_TOKEN = "com.tencent.mm.sdk.plugin.Intent.REQUEST_TOKEN";
        public static final String ACCESS_TOKEN = "com.tencent.mm.sdk.plugin.Intent.ACCESS_TOKEN";
        public static final String PERMISSIONS = "com.tencent.mm.sdk.plugin.Intent.PERMISSIONS";
        public static final String ACTION_REQUEST_TOKEN = "com.tencent.mm.sdk.plugin.Intent.ACTION_REQUEST_TOKEN";
        public static final String ACTION_RESPONSE = "com.tencent.mm.sdk.plugin.Intent.ACTION_RESPONSE";
        public static final String ACTION_QRCODE_SCANNED = "com.tencent.mm.sdk.plugin.Intent.ACTION_QRCODE_SCANNED";
        public static final String PLUGIN_PACKAGE_PATTERN = "com.tencent.mm.plugin";
        public static final String APP_PACKAGE_PATTERN = "com.tencent.mm";
    }

    public static final class OAuth
    implements BaseColumns {
        public static final Uri CONTENT_URI = Uri.parse((String)"content://com.tencent.mm.sdk.plugin.provider/oauth");
        public static final String API_KEY = "apiKey";
        public static final String REQUEST_TOKEN = "requestToken";
        public static final String ACCESS_TOKEN = "accessToken";
        public static final String SECRET = "secret";
        public static final String ACTION_REQUEST_TOKEN = "request_token";

        private OAuth() {
        }
    }

    public static final class PluginDB
    implements BaseColumns {
        public static final Uri CONTENT_URI = Uri.parse((String)"content://com.tencent.mm.sdk.plugin.provider/plugindb");
        public static final String KEY = "key";
        public static final String TYPE = "type";
        public static final String VALUE = "value";

        private PluginDB() {
        }
    }

    public static final class SharedPref
    implements BaseColumns {
        public static final Uri CONTENT_URI = Uri.parse((String)"content://com.tencent.mm.sdk.plugin.provider/sharedpref");
        public static final String KEY = "key";
        public static final String TYPE = "type";
        public static final String VALUE = "value";

        private SharedPref() {
        }
    }

    public static final class Resolver {
        private Resolver() {
        }

        public static int getType(Object object) {
            if (object == null) {
                Log.e("MicroMsg.SDK.PluginProvider.Resolver", "unresolve failed, null value");
                return 0;
            }
            if (object instanceof Integer) {
                return 1;
            }
            if (object instanceof Long) {
                return 2;
            }
            if (object instanceof String) {
                return 3;
            }
            if (object instanceof Boolean) {
                return 4;
            }
            if (object instanceof Float) {
                return 5;
            }
            if (object instanceof Double) {
                return 6;
            }
            Log.e("MicroMsg.SDK.PluginProvider.Resolver", "unresolve failed, unknown type=" + object.getClass().toString());
            return 0;
        }

        public static boolean unresolveObj(ContentValues contentValues, Object object) {
            int n = Resolver.getType(object);
            if (n == 0) {
                return false;
            }
            contentValues.put("type", Integer.valueOf(n));
            contentValues.put("value", object.toString());
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static Object resolveObj(int n, String string) {
            try {
                switch (n) {
                    case 1: {
                        return Integer.valueOf(string);
                    }
                    case 2: {
                        return Long.valueOf(string);
                    }
                    case 3: {
                        return string;
                    }
                    case 4: {
                        return Boolean.valueOf(string);
                    }
                    case 5: {
                        return Float.valueOf(string);
                    }
                    case 6: {
                        return Double.valueOf(string);
                    }
                }
                Log.e("MicroMsg.SDK.PluginProvider.Resolver", "unknown type");
                return null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return null;
        }
    }
}

