/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.sdk.storage;

import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import com.tencent.mm.sdk.platformtools.Log;
import com.tencent.mm.sdk.storage.ISQLiteDatabase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContentProviderDB<T>
implements ISQLiteDatabase {
    private final Context R;

    public ContentProviderDB(Context context) {
        this.R = context;
    }

    public abstract Uri getUriFromTable(String var1);

    @Override
    public Cursor query(String string, String[] stringArray, String string2, String[] stringArray2, String string3, String string4, String string5) {
        string3 = this.getUriFromTable(string);
        if (string3 == null) {
            Log.e("MicroMsg.SDK.MContentProviderDB", "get uri from table failed, table=" + string);
            return new MatrixCursor(stringArray);
        }
        string = this.R.getContentResolver().query((Uri)string3, stringArray, string2, stringArray2, string5);
        if (string == null) {
            return new MatrixCursor(stringArray);
        }
        return string;
    }

    @Override
    public Cursor rawQuery(String string, String[] stringArray) {
        Log.e("MicroMsg.SDK.MContentProviderDB", "do not support, rawQuery sql=" + string);
        return null;
    }

    @Override
    public boolean execSQL(String string, String string2) {
        Log.e("MicroMsg.SDK.MContentProviderDB", "do not support, execSQL sql=" + string2);
        return false;
    }

    @Override
    public long insert(String string, String string2, ContentValues contentValues) {
        string2 = this.getUriFromTable(string);
        if (string2 == null) {
            Log.e("MicroMsg.SDK.MContentProviderDB", "get uri from table failed, table=" + string);
            return -1L;
        }
        return ContentUris.parseId((Uri)this.R.getContentResolver().insert((Uri)string2, contentValues));
    }

    @Override
    public int update(String string, ContentValues contentValues, String string2, String[] stringArray) {
        Uri uri = this.getUriFromTable(string);
        if (uri == null) {
            Log.e("MicroMsg.SDK.MContentProviderDB", "get uri from table failed, table=" + string);
            return 0;
        }
        return this.R.getContentResolver().update(uri, contentValues, string2, stringArray);
    }

    @Override
    public long replace(String string, String string2, ContentValues contentValues) {
        Log.e("MicroMsg.SDK.MContentProviderDB", "do not support, replace table=" + string);
        return 0L;
    }

    @Override
    public int delete(String string, String string2, String[] stringArray) {
        Uri uri = this.getUriFromTable(string);
        if (uri == null) {
            Log.e("MicroMsg.SDK.MContentProviderDB", "get uri from table failed, table=" + string);
            return 0;
        }
        return this.R.getContentResolver().delete(uri, string2, stringArray);
    }
}

