/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.sdk.storage;

import android.content.ContentValues;
import android.database.Cursor;
import com.tencent.mm.sdk.platformtools.Log;
import com.tencent.mm.sdk.platformtools.Util;
import com.tencent.mm.sdk.storage.ISQLiteDatabase;
import com.tencent.mm.sdk.storage.MAutoDBItem;
import com.tencent.mm.sdk.storage.MStorage;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MAutoStorage<T extends MAutoDBItem>
extends MStorage {
    private ISQLiteDatabase P;
    private final String bL;
    private final String[] columns;

    public abstract String getTableName();

    public abstract String getPrimaryKey();

    public abstract String[] getColumns();

    public MAutoStorage(ISQLiteDatabase iSQLiteDatabase) {
        this.P = iSQLiteDatabase;
        this.bL = Util.isNullOrNil(this.getPrimaryKey()) ? "rowid" : this.getPrimaryKey();
        this.columns = this.getColumns();
    }

    public static List<String> getCreateSQLs(Field[] object, String string, String stringArray, String ... stringArray2) {
        LinkedList<String> linkedList = new LinkedList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CREATE TABLE IF NOT EXISTS " + string + " ( ");
        object = MAutoDBItem.identify((Field[])object, stringBuilder, (String)stringArray);
        stringBuilder.append(");");
        linkedList.addFirst(stringBuilder.toString());
        if (stringArray2 != null && stringArray2.length > 0) {
            stringArray = stringArray2;
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[i];
                if (string2 == null || string2.length() <= 0) continue;
                if (object.get(string2) == null) {
                    Log.e("MicroMsg.SDK.MAutoStorage", "skipped invalid index: " + string2 + ", not found in fields");
                }
                linkedList.add("CREATE INDEX IF NOT EXISTS _mindex_" + string + "_" + string2 + "_ ON " + string + "(" + string2 + ");");
            }
        }
        return linkedList;
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> getUpdateSQLs(Field[] object3, String string, ISQLiteDatabase object2) {
        String string2;
        void var1_4;
        Object object;
        LinkedList<String> linkedList = new LinkedList<String>();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        object = object.rawQuery("PRAGMA table_info( " + (String)var1_4 + " )", null);
        while (object.moveToNext()) {
            string2 = object.getString(object.getColumnIndex("name"));
            String string3 = object.getString(object.getColumnIndex("type"));
            hashMap.put(string2, string3);
        }
        object.close();
        string2 = null;
        for (Map.Entry entry : MAutoDBItem.identify((Field[])object3, null, null).entrySet()) {
            object = (String)entry.getValue();
            String string4 = (String)entry.getKey();
            if (object == null | ((String)object).length() <= 0) continue;
            string2 = (String)hashMap.get(string4);
            if (string2 == null) {
                linkedList.add("ALTER TABLE " + (String)var1_4 + " ADD COLUMN " + string4 + " " + (String)object + ";");
                hashMap.remove(string4);
                continue;
            }
            if (string2.equalsIgnoreCase((String)object)) continue;
            Log.e("MicroMsg.SDK.MAutoStorage", "conflicting alter table on column: " + string4 + ", " + string2 + "<o-n>" + (String)object);
            hashMap.remove(string4);
        }
        return linkedList;
    }

    public boolean insert(T t) {
        ContentValues contentValues = ((MAutoDBItem)t).convertTo();
        if (contentValues == null || contentValues.size() <= 0) {
            this.e("insert failed, value.size <= 0");
            return false;
        }
        ((MAutoDBItem)t).systemRowid = this.P.insert(this.getTableName(), this.bL, ((MAutoDBItem)t).convertTo());
        if (((MAutoDBItem)t).systemRowid <= 0L) {
            this.e("insert failed");
            return false;
        }
        this.doNotify(this.bL);
        return true;
    }

    public boolean delete(T object, String ... stringArray) {
        if ((object = ((MAutoDBItem)object).convertTo()) == null || object.size() <= 0) {
            this.e("delete failed, value.size <= 0");
            return false;
        }
        if (stringArray == null || stringArray.length <= 0) {
            this.d("delete with primary key");
            boolean bl = this.P.delete(this.getTableName(), this.bL + " = ?", new String[]{Util.nullAsNil(object.getAsString(this.bL))}) > 0;
            if (bl) {
                this.doNotify();
            }
            return bl;
        }
        StringBuilder stringBuilder = MAutoStorage.a(object, stringArray);
        if (stringBuilder == null) {
            this.e("delete failed, check keys failed");
            return false;
        }
        if (this.P.delete(this.getTableName(), stringBuilder.toString(), MAutoStorage.a(stringArray, object)) > 0) {
            this.doNotify(this.bL);
            return true;
        }
        this.e("delete failed");
        return false;
    }

    public boolean delete(long l) {
        boolean bl = this.P.delete(this.getTableName(), "rowid = ?", new String[]{String.valueOf(l)}) > 0;
        if (bl) {
            this.notify();
        }
        return bl;
    }

    public boolean get(long l, T t) {
        Cursor cursor = this.P.query(this.getTableName(), this.columns, "rowid = ?", new String[]{String.valueOf(l)}, null, null, null);
        if (cursor.moveToFirst()) {
            ((MAutoDBItem)t).convertFrom(cursor);
            cursor.close();
            return true;
        }
        cursor.close();
        return false;
    }

    public boolean get(T t, String ... cursor) {
        ContentValues contentValues = ((MAutoDBItem)t).convertTo();
        if (contentValues == null || contentValues.size() <= 0) {
            this.e("get failed, value.size <= 0");
            return false;
        }
        if (cursor == null || ((String[])cursor).length <= 0) {
            this.d("get with primary key");
            Cursor cursor2 = this.P.query(this.getTableName(), this.columns, this.bL + " = ?", new String[]{Util.nullAsNil(contentValues.getAsString(this.bL))}, null, null, null);
            if (cursor2.moveToFirst()) {
                ((MAutoDBItem)t).convertFrom(cursor2);
                cursor2.close();
                return true;
            }
            cursor2.close();
            return false;
        }
        StringBuilder stringBuilder = MAutoStorage.a(contentValues, (String[])cursor);
        if (stringBuilder == null) {
            this.e("get failed, check keys failed");
            return false;
        }
        cursor = this.P.query(this.getTableName(), this.columns, stringBuilder.toString(), MAutoStorage.a((String[])cursor, contentValues), null, null, null);
        if (cursor.moveToFirst()) {
            ((MAutoDBItem)t).convertFrom(cursor);
            cursor.close();
            return true;
        }
        cursor.close();
        this.d("get failed, not found");
        return false;
    }

    public boolean update(long l, T object) {
        if ((object = ((MAutoDBItem)object).convertTo()) == null || object.size() <= 0) {
            this.e("update failed, value.size <= 0");
            return false;
        }
        Cursor cursor = this.P.query(this.getTableName(), this.columns, "rowid = ?", new String[]{String.valueOf(l)}, null, null, null);
        if (MAutoDBItem.checkIOEqual(object, cursor)) {
            cursor.close();
            this.d("no need replace , fields no change");
            return true;
        }
        cursor.close();
        boolean bl = this.P.update(this.getTableName(), (ContentValues)object, "rowid = ?", new String[]{String.valueOf(l)}) > 0;
        if (bl) {
            this.doNotify();
        }
        return bl;
    }

    public boolean update(T object, String ... stringArray) {
        if ((object = ((MAutoDBItem)object).convertTo()) == null || object.size() <= 0) {
            this.e("update failed, value.size <= 0");
            return false;
        }
        if (stringArray == null || stringArray.length <= 0) {
            this.d("update with primary key");
            if (this.a((ContentValues)object)) {
                this.d("no need replace , fields no change");
                return true;
            }
            boolean bl = this.P.update(this.getTableName(), (ContentValues)object, this.bL + " = ?", new String[]{Util.nullAsNil(object.getAsString(this.bL))}) > 0;
            if (bl) {
                this.doNotify();
            }
            return bl;
        }
        StringBuilder stringBuilder = MAutoStorage.a(object, stringArray);
        if (stringBuilder == null) {
            this.e("update failed, check keys failed");
            return false;
        }
        if (this.P.update(this.getTableName(), (ContentValues)object, stringBuilder.toString(), MAutoStorage.a(stringArray, object)) > 0) {
            this.doNotify(this.bL);
            return true;
        }
        this.e("update failed");
        return false;
    }

    public boolean replace(T t) {
        Assert.assertTrue((String)"replace primaryKey == null", (!Util.isNullOrNil(this.bL) ? 1 : 0) != 0);
        ContentValues contentValues = ((MAutoDBItem)t).convertTo();
        if (contentValues == null || contentValues.size() != ((MAutoDBItem)t).fields().length + (contentValues.containsKey("rowid") ? 1 : 0)) {
            this.e("replace failed, cv.size() != item.fields().length");
            return false;
        }
        if (this.a(contentValues)) {
            this.d("no need replace , fields no change");
            return true;
        }
        if (this.P.replace(this.getTableName(), this.bL, contentValues) > 0L) {
            this.doNotify(this.bL);
            return true;
        }
        this.e("replace failed");
        return false;
    }

    private boolean a(ContentValues contentValues) {
        Cursor cursor = this.P.query(this.getTableName(), this.columns, this.bL + " = ?", new String[]{Util.nullAsNil(contentValues.getAsString(this.bL))}, null, null, null);
        boolean bl = MAutoDBItem.checkIOEqual(contentValues, cursor);
        cursor.close();
        return bl;
    }

    public Cursor getAll() {
        return this.P.query(this.getTableName(), this.columns, null, null, null, null, null);
    }

    public int getCount() {
        String string = "select count(*) from " + this.getTableName();
        if ((string = this.rawQuery(string, new String[0])) != null) {
            string.moveToFirst();
            int n = string.getInt(0);
            string.close();
            return n;
        }
        return 0;
    }

    public Cursor rawQuery(String string, String ... stringArray) {
        return this.P.rawQuery(string, stringArray);
    }

    private static StringBuilder a(ContentValues contentValues, String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(string + " = ? AND ");
            if (contentValues.get(string) != null) continue;
            return null;
        }
        stringBuilder.append(" 1=1");
        return stringBuilder;
    }

    private static String[] a(String[] stringArray, ContentValues contentValues) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = Util.nullAsNil(contentValues.getAsString(stringArray[i]));
        }
        return stringArray2;
    }

    private void d(String string) {
        Log.d("MicroMsg.SDK.MAutoStorage", this.getTableName() + ":" + string);
    }

    private void e(String string) {
        Log.e("MicroMsg.SDK.MAutoStorage", this.getTableName() + ":" + string);
    }
}

