/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.sdk.storage;

import android.os.Handler;
import android.os.Looper;
import com.tencent.mm.sdk.platformtools.Log;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.concurrent.CopyOnWriteArraySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MStorageEvent<T, E> {
    private int bP = 0;
    private final Hashtable<T, Object> bQ = new Hashtable();
    private final CopyOnWriteArraySet<E> bR = new CopyOnWriteArraySet();

    public void lock() {
        ++this.bP;
    }

    public void unlock() {
        --this.bP;
        if (this.bP <= 0) {
            this.bP = 0;
            this.e();
        }
    }

    public boolean isLocked() {
        return this.bP > 0;
    }

    public void add(T t, Looper looper) {
        if (!this.bQ.containsKey(t)) {
            if (looper != null) {
                this.bQ.put(t, looper);
                return;
            }
            this.bQ.put(t, new Object());
        }
    }

    public boolean event(E e) {
        return this.bR.add(e);
    }

    public void remove(T t) {
        this.bQ.remove(t);
    }

    public void removeAll() {
        this.bQ.clear();
    }

    public void doNotify() {
        if (!this.isLocked()) {
            this.e();
        }
    }

    private void e() {
        HashSet<T> hashSet = new HashSet<T>(this.bQ.keySet());
        if (hashSet.size() <= 0) {
            return;
        }
        HashMap<Looper, Handler> hashMap = new HashMap<Looper, Handler>();
        for (final Object e : hashSet) {
            Object object = this.bQ.get(e);
            for (final E e2 : this.bR) {
                if (e2 == null) continue;
                if (object == null) {
                    Log.f("MicroMsg.SDK.MStorageEvent", "handle listener fatal unknown bug");
                    continue;
                }
                if (object instanceof Looper) {
                    Looper looper = (Looper)object;
                    Handler handler = (Handler)hashMap.get(looper);
                    if (handler == null) {
                        handler = new Handler(looper);
                        hashMap.put(looper, handler);
                    }
                    handler.post(new Runnable(){

                        public void run() {
                            MStorageEvent.this.processEvent(e, e2);
                        }
                    });
                    continue;
                }
                this.processEvent(e, e2);
            }
        }
        this.bR.clear();
    }

    protected abstract void processEvent(T var1, E var2);
}

