/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.encoder;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.Writer;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.pdf417.encoder.Compaction;
import com.google.zxing.pdf417.encoder.Dimensions;
import com.google.zxing.pdf417.encoder.PDF417;
import java.util.EnumMap;
import java.util.Map;

public final class PDF417Writer
implements Writer {
    @Override
    public BitMatrix encode(String contents, BarcodeFormat format, int width, int height, Map<EncodeHintType, ?> hints) throws WriterException {
        if (format != BarcodeFormat.PDF_417) {
            throw new IllegalArgumentException("Can only encode PDF_417, but got " + (Object)((Object)format));
        }
        PDF417 encoder = new PDF417();
        if (hints != null) {
            if (hints.containsKey((Object)EncodeHintType.PDF417_COMPACT)) {
                encoder.setCompact((Boolean)hints.get((Object)EncodeHintType.PDF417_COMPACT));
            }
            if (hints.containsKey((Object)EncodeHintType.PDF417_COMPACTION)) {
                encoder.setCompaction((Compaction)((Object)hints.get((Object)EncodeHintType.PDF417_COMPACTION)));
            }
            if (hints.containsKey((Object)EncodeHintType.PDF417_DIMENSIONS)) {
                Dimensions dimensions = (Dimensions)hints.get((Object)EncodeHintType.PDF417_DIMENSIONS);
                encoder.setDimensions(dimensions.getMaxCols(), dimensions.getMinCols(), dimensions.getMaxRows(), dimensions.getMinRows());
            }
        }
        return PDF417Writer.bitMatrixFromEncoder(encoder, contents, width, height);
    }

    @Override
    public BitMatrix encode(String contents, BarcodeFormat format, int width, int height) throws WriterException {
        return this.encode(contents, format, width, height, null);
    }

    @Deprecated
    public BitMatrix encode(String contents, BarcodeFormat format, boolean compact, int width, int height, int minCols, int maxCols, int minRows, int maxRows, Compaction compaction) throws WriterException {
        EnumMap<EncodeHintType, Object> hints = new EnumMap<EncodeHintType, Object>(EncodeHintType.class);
        hints.put(EncodeHintType.PDF417_COMPACT, Boolean.valueOf(compact));
        hints.put(EncodeHintType.PDF417_COMPACTION, (Object)compaction);
        hints.put(EncodeHintType.PDF417_DIMENSIONS, new Dimensions(minCols, maxCols, minRows, maxRows));
        return this.encode(contents, format, width, height, hints);
    }

    private static BitMatrix bitMatrixFromEncoder(PDF417 encoder, String contents, int width, int height) throws WriterException {
        int scaleY;
        int scaleX;
        int scale;
        int errorCorrectionLevel = 2;
        encoder.generateBarcodeLogic(contents, errorCorrectionLevel);
        int lineThickness = 2;
        int aspectRatio = 4;
        byte[][] originalScale = encoder.getBarcodeMatrix().getScaledMatrix(lineThickness, aspectRatio * lineThickness);
        boolean rotated = false;
        if (height > width ^ originalScale[0].length < originalScale.length) {
            originalScale = PDF417Writer.rotateArray(originalScale);
            rotated = true;
        }
        if ((scale = (scaleX = width / originalScale[0].length) < (scaleY = height / originalScale.length) ? scaleX : scaleY) > 1) {
            byte[][] scaledMatrix = encoder.getBarcodeMatrix().getScaledMatrix(scale * lineThickness, scale * aspectRatio * lineThickness);
            if (rotated) {
                scaledMatrix = PDF417Writer.rotateArray(scaledMatrix);
            }
            return PDF417Writer.bitMatrixFrombitArray(scaledMatrix);
        }
        return PDF417Writer.bitMatrixFrombitArray(originalScale);
    }

    private static BitMatrix bitMatrixFrombitArray(byte[][] input) {
        int whiteSpace = 30;
        BitMatrix output = new BitMatrix(input[0].length + 2 * whiteSpace, input.length + 2 * whiteSpace);
        output.clear();
        int y = 0;
        int yOutput = output.getHeight() - whiteSpace;
        while (y < input.length) {
            int x = 0;
            while (x < input[0].length) {
                if (input[y][x] == 1) {
                    output.set(x + whiteSpace, yOutput);
                }
                ++x;
            }
            ++y;
            --yOutput;
        }
        return output;
    }

    private static byte[][] rotateArray(byte[][] bitarray) {
        byte[][] temp = new byte[bitarray[0].length][bitarray.length];
        int ii = 0;
        while (ii < bitarray.length) {
            int inverseii = bitarray.length - ii - 1;
            int jj = 0;
            while (jj < bitarray[0].length) {
                temp[jj][inverseii] = bitarray[ii][jj];
                ++jj;
            }
            ++ii;
        }
        return temp;
    }
}

